SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       i.name AS INDEX_NAME,
       user_seeks, user_scans, user_lookups, user_updates
FROM   sys.indexes AS i
       INNER JOIN sys.objects AS o
             ON i.object_id = o.object_id
       INNER JOIN sys.schemas AS s
             ON o.schema_id = s.schema_id
       LEFT OUTER JOIN sys.dm_db_index_usage_stats AS ius
             ON ius.object_id = i.object_id
                AND ius.index_id = i.index_id
WHERE  i.index_id > 1 AND o."type" IN ('U', 'V') AND database_id = DB_ID()
ORDER  BY user_seeks, user_lookups, user_scans, user_updates DESC;

--> NOTA : la requte a t modifi dans sa clause WHERE